CONTAINER OctaneMaterial
{
    NAME OctaneMaterial;

    GROUP
    {
        MATPREVIEW OCT_MATERIAL_MAT_PREVIEW { OPEN; MIN_WIDTH 100; MIN_HEIGHT 100; NO_SIZE_POPUP; }
    }

    INCLUDE Mbase;

    GROUP Obaselist
    {
        LONG OCT_MATERIAL_TYPE
        {
            CYCLE
            {
                OCT_MATERIAL_DIFFUSE;
                OCT_MATERIAL_GLOSSY;
                OCT_MATERIAL_SPECULAR;
                OCT_MAT_METAL;
                OCT_MAT_TOON;
                OCT_MAT_UNIVERSAL;
            }
        }
        LONG OCT_MAT_BRDF_MODEL
        {
            CYCLE
            {
                OCT_MAT_BRDF_OCTANE;
                OCT_MAT_BRDF_BECKMANN;
                OCT_MAT_BRDF_GGX;
                OCT_MAT_BRDF_WARD;
            }
        }

        SEPARATOR { LINE; }
        BUTTON OCT_MATERIAL_NODE_EDITOR {}

        GROUP
        {
            LAYOUTGROUP; COLUMNS 2; MATEDCOLUMNS 2;
            GROUP
            {
                BOOL OCT_MAT_USE_COLOR 			{ PARENTMSG ID_MATERIAL_DIFFUSE_GROUP; }
                BOOL OCT_MAT_USE_SPECULAR               { PARENTMSG ID_MATERIAL_SPECULAR_GROUP; }
                BOOL OCT_MAT_USE_SPECULAR_MAP           { PARENTMSG ID_MATERIAL_SPECULAR_MAP_GROUP; }
                BOOL OCT_MAT_USE_ROUGHNESS              { PARENTMSG ID_MATERIAL_ROUGHNESS_GROUP; }
                BOOL OCT_MAT_USE_REFLECTION 		{ PARENTMSG ID_MATERIAL_REFLECTION_GROUP; }
                BOOL OCT_MAT_USE_ANISO                  { PARENTMSG ID_MATERIAL_ANISOTROPY_GROUP; }
                BOOL OCT_MAT_USE_TOON                   { PARENTMSG ID_MATERIAL_TOON_GROUP; }
                BOOL OCT_MAT_USE_SHEEN                  { PARENTMSG ID_MATERIAL_SHEEN_GROUP; }
                BOOL OCT_MAT_USE_COATING                { PARENTMSG ID_MATERIAL_COATING_GROUP; }
                BOOL OCT_MAT_USE_FILMWIDTH              { PARENTMSG ID_MATERIAL_FILMWIDTH_GROUP; }
                //BOOL OCT_MAT_USE_FILMINDEX            { PARENTMSG ID_MATERIAL_FILMINDEX_GROUP; }
                BOOL OCT_MAT_USE_BUMP			{ PARENTMSG ID_MATERIAL_BUMP_GROUP; }
                BOOL OCT_MAT_USE_NORMAL			{ PARENTMSG ID_MATERIAL_NORMAL_GROUP; }
                BOOL OCT_MAT_USE_DISPLACEMENT           { PARENTMSG ID_MATERIAL_DISP_GROUP; }
                BOOL OCT_MAT_USE_OPACITY                { PARENTMSG ID_MATERIAL_OPACITY_GROUP; }
                BOOL OCT_MAT_USE_DISPERSION             { PARENTMSG ID_MATERIAL_DISPERSION_GROUP; }
                //BOOL OCT_MAT_USE_BASEIOR                { PARENTMSG ID_MATERIAL_BASE_IOR_GROUP; }
                BOOL OCT_MAT_USE_INDEX			{ PARENTMSG ID_MATERIAL_INDEX_GROUP; }
                BOOL OCT_MAT_USE_TRANSMISSION           { PARENTMSG ID_MATERIAL_TRANSMISSION_GROUP; }
                BOOL OCT_MAT_USE_EMISSION               { PARENTMSG ID_MATERIAL_EMISSION_GROUP; }
                BOOL OCT_MAT_USE_MEDIUM			{ PARENTMSG ID_MATERIAL_MEDIUM_GROUP; }
                BOOL OCT_MAT_USE_FAKESHADOW             { PARENTMSG ID_MATERIAL_FAKESHADOWS_GROUP; }
                BOOL OCT_MAT_USE_COMMON     		{ PARENTMSG ID_MATERIAL_COMMON_GROUP; }
                BOOL OCT_MAT_USE_EDITOR			{ PARENTMSG ID_OCT_MATERIALGROUP_EDITOR; }
            }
        }

        BITMAPBUTTON  OCT_MATERIAL_HELPBUTTON {ANIM OFF;}

    }


    GROUP ID_MATERIAL_DIFFUSE_GROUP
    {
        OPEN; DEFAULT 1;
        VECTOR      OCT_MATERIAL_DIFFUSE_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
        REAL        OCT_MATERIAL_DIFFUSE_FLOAT {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;  }
        SEPARATOR   {}
        SHADERLINK  OCT_MATERIAL_DIFFUSE_LINK {  OPEN; INPORT; }
        REAL        OCT_MATERIAL_DIFFUSE_MIX {  MIN 0.0; STEP 0.01; MAX 1; MINSLIDER 0; MAXSLIDER 1;  CUSTOMGUI OCTNSLIDER; }
    }

    SEPARATOR {}

    GROUP ID_MATERIAL_SPECULAR_GROUP
    {
        VECTOR OCT_MATERIAL_SPECULAR_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
        REAL OCT_MATERIAL_SPECULAR_FLOAT {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
        SEPARATOR {}
        SHADERLINK OCT_MATERIAL_SPECULAR_LINK { OPEN; INPORT;}
        REAL    OCT_MATERIAL_SPECULAR_MIX {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
    }

    GROUP ID_MATERIAL_SPECULAR_MAP_GROUP
    {
        COLUMNS 1;
        GROUP ID_MATERIAL_SPECULAR_MAP_FLOAT_GROUP
        {
            COLUMNS 2;
            REAL OCT_MAT_SPECULAR_MAP_FLOAT { SCALE_H; MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            BUTTON OCT_MAT_ADD_SPECULAR_MAP_BTN   { ANIM OFF; }
        }
        SHADERLINK OCT_MAT_SPECULAR_MAP_LINK { OPEN; INPORT;}
    }


    GROUP ID_MATERIAL_ROUGHNESS_GROUP
    {
        VECTOR OCT_MATERIAL_ROUGHNESS_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
        REAL OCT_MATERIAL_ROUGHNESS_FLOAT {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
        SEPARATOR {}
        SHADERLINK OCT_MATERIAL_ROUGHNESS_LINK { OPEN; INPORT;}
        REAL    OCT_MATERIAL_ROUGHNESS_MIX {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
    }


    GROUP ID_MATERIAL_REFLECTION_GROUP
    {
        VECTOR OCT_MAT_REFLECTION_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
        REAL OCT_MAT_REFLECTION_FLOAT {  MIN 0.0; STEP 0.001; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
        SEPARATOR {}
        SHADERLINK OCT_MAT_REFLECTION_LINK { OPEN; INPORT;}
        REAL    OCT_MAT_REFLECTION_MIX {  MIN 0.0; STEP 0.001; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
    }

    GROUP ID_MATERIAL_ANISOTROPY_GROUP
    {
        REAL OCT_MAT_ANISOTROPY_FLOAT {  MIN -1.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
        SHADERLINK OCT_MAT_ANISOTROPY_ROTATION_LINK { OPEN; INPORT;}
    }

    GROUP ID_MATERIAL_SHEEN_GROUP
    {
        GROUP OCT_MAT_SHEEN_MAP_FLOAT_GROUP
        {
            COLUMNS 2;
            REAL OCT_MAT_SHEEN_MAP_FLOAT { SCALE_H; MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            BUTTON OCT_MAT_ADD_SHEEN_MAP_BTN   { ANIM OFF; }
        }
        SHADERLINK OCT_MAT_SHEEN_LINK { OPEN; INPORT;}

        GROUP OCT_MAT_SHEEN_ROUGHNESS_GROUP
        {
            COLUMNS 2;
            REAL OCT_MAT_SHEEN_ROUGH_FLOAT { SCALE_H; MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            BUTTON OCT_MAT_ADD_SHEEN_ROUGH_BTN   { ANIM OFF; }
        }
        SHADERLINK OCT_MAT_SHEEN_ROUGHNESS_LINK { OPEN; INPORT;}

        SHADERLINK OCT_MAT_SHEEN_BUMP_LINK { OPEN; INPORT;}
        SHADERLINK OCT_MAT_SHEEN_NORMAL_LINK { OPEN; INPORT;}
    }

    GROUP ID_MATERIAL_COATING_GROUP
    {
        GROUP OCT_MAT_COATING_MAP_FLOAT_GROUP
        {
            COLUMNS 2;
            REAL OCT_MAT_COATING_MAP_FLOAT { SCALE_H; MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            BUTTON OCT_MAT_ADD_COATING_MAP_BTN   { ANIM OFF; }
        }
        SHADERLINK OCT_MAT_COATING_LINK { OPEN; INPORT;}

        GROUP OCT_MAT_COATING_MAP_ROUGH_GROUP
        {
            COLUMNS 2;
            REAL OCT_MAT_COATING_ROUGHNESS_FLOAT  { SCALE_H; MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            BUTTON OCT_MAT_ADD_COATING_ROUGHNESS_BTN   { ANIM OFF; }
        }
        SHADERLINK OCT_MAT_COATING_ROUGHNESS_LINK { OPEN; INPORT;}

        REAL OCT_MAT_COATING_INDEX            { MIN 1.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }

        SHADERLINK OCT_MAT_COATING_BUMP_LINK { OPEN; INPORT;}
        SHADERLINK OCT_MAT_COATING_NORMAL_LINK { OPEN; INPORT;}
    }

    GROUP ID_MATERIAL_FILMWIDTH_GROUP
    {
        VECTOR OCT_MATERIAL_FILMWIDTH_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
        REAL OCT_MATERIAL_FILMWIDTH_FLOAT {  MIN 0.0; STEP 0.001; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
        SEPARATOR {}
        SHADERLINK OCT_MATERIAL_FILMWIDTH_LINK { OPEN; INPORT;}
        SEPARATOR {}
        REAL OCT_MATERIAL_FILMINDEX {  MIN 1.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER;; }
    }


    GROUP ID_MATERIAL_TOON_GROUP
    {
        LONG OCT_MAT_TOON_LIGHT_MODE
        {
            CYCLE
            {
                OCT_MAT_TOON_LM_TOON_LIGHTS;
                OCT_MAT_TOON_LM_CAMERA_LIGHTS;
            }
        }

        BUTTON OCT_MAT_ADD_TOON_DIFFUSE_RAMP_BTN   { ANIM OFF; }
        SHADERLINK OCT_MAT_TOON_DIFFUSE_RAMP  { OPEN;  INPORT; ACCEPT {ToonRampTexture; } }

        BUTTON OCT_MAT_ADD_TOON_SPECULAR_RAMP_BTN   { ANIM OFF; }
        SHADERLINK OCT_MAT_TOON_SPECULAR_RAMP { OPEN;  INPORT; ACCEPT {ToonRampTexture; } }

        SHADERLINK OCT_MAT_TOON_OUTLINE_COLOR { OPEN; INPORT;}
        REAL OCT_MAT_TOON_OUTLINE_THICKNESS {  MIN 0.0; STEP 0.01; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
    }

    GROUP   ID_MATERIAL_FAKESHADOWS_GROUP
    {
            BOOL OCT_MATERIAL_FAKESHADOW {   }
    }

    GROUP   ID_MATERIAL_BUMP_GROUP
    {
          SEPARATOR {}
          SHADERLINK OCT_MATERIAL_BUMP_LINK { OPEN; INPORT; }
    }

    GROUP   ID_MATERIAL_NORMAL_GROUP
    {
            SEPARATOR {}
            SHADERLINK OCT_MATERIAL_NORMAL_LINK { OPEN; INPORT; }
    }

    GROUP   ID_MATERIAL_DISP_GROUP
    {
            BUTTON ID_MATERIAL_ADD_DISPLACEMENT   { ANIM OFF; }
            SHADERLINK OCT_MATERIAL_DISPLACEMENT_LINK { ACCEPT {OctaneDisplacement;} }
    }

    GROUP   ID_MATERIAL_OPACITY_GROUP
    {
            VECTOR OCT_MATERIAL_OPACITY_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
            REAL OCT_MATERIAL_OPACITY_FLOAT {  MIN 0.0; STEP 0.001; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            SEPARATOR {}
            SHADERLINK OCT_MATERIAL_OPACITY_LINK { OPEN; INPORT; }
            REAL    OCT_MATERIAL_OPACITY_MIX {  MIN 0.0; STEP 0.001; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
    }

    GROUP   ID_MATERIAL_DISPERSION_GROUP
    {
            REAL OCT_MATERIAL_DISPCOEFF_B {  MIN 0.0; STEP 0.001; MAX 0.1;  CUSTOMGUI OCTNSLIDER;; }
    }

//    GROUP   ID_MATERIAL_BASE_IOR_GROUP
//    {
//            REAL OCT_DIELECTRIC_INDEX   {  MIN 1.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
//    }

    GROUP   ID_MATERIAL_INDEX_GROUP
    {
            REAL OCT_MATERIAL_INDEX    {  MIN 1.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
            SHADERLINK OCT_MAT_1_DIV_IOR_LINK { OPEN; INPORT; }
            SEPARATOR {}

            LONG OCT_MAT_METALLIC_MODE
            {
                CYCLE
                {
                    OCT_MAT_METAL_REFL_ARTISTIC;
                    OCT_MAT_METAL_REFL_IOR_COLOR;
                    OCT_MAT_METAL_REFL_RGB_IOR;
                }
            }

            GROUP ID_MATERIAL_INDEX2_GROUP
            {
                COLUMNS 2;
                REAL OCT_MATERIAL_INDEX_N {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL OCT_MATERIAL_INDEX_K {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL OCT_MATERIAL_GR_INDEX_N {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL OCT_MATERIAL_GR_INDEX_K {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL OCT_MATERIAL_BL_INDEX_N {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
                REAL OCT_MATERIAL_BL_INDEX_K {  SCALE_H; MIN 0.0; STEP 0.001; MAX 8.0;  CUSTOMGUI OCTNSLIDER; ANIM ON; }
            }
    }

    GROUP   ID_MATERIAL_TRANSMISSION_GROUP
    {
            VECTOR OCT_MATERIAL_TRANSMISSION_COLOR { OPEN; CUSTOMGUI OCTANE_COLORGUI;}
            REAL OCT_MATERIAL_TRANSMISSION_FLOAT {  MIN 0.0; STEP 0.001; MAX 1.0; MAXSLIDER 1.0;  CUSTOMGUI OCTNSLIDER;; }
            SHADERLINK OCT_MATERIAL_TRANSMISSION_LINK { OPEN; INPORT; }
    }

    GROUP   ID_MATERIAL_EMISSION_GROUP
    {
            GROUP
            {
                COLUMNS 3;
                BUTTON ID_MATERIAL_ADD_BB_EMIS    { ANIM OFF; }
                BUTTON ID_MATERIAL_ADD_TEX_EMIS   { ANIM OFF; }
            }
            SHADERLINK  OCT_MATERIAL_EMISSION  { ACCEPT {BlackBodyEmission;  TextureEmission; } }
    }


    GROUP   ID_MATERIAL_MEDIUM_GROUP
    {
            GROUP
            {
                COLUMNS 3;
                BUTTON ID_MATERIAL_ADD_ABS_MEDIUM   { ANIM OFF; }
                BUTTON ID_MATERIAL_ADD_SCT_MEDIUM   { ANIM OFF; }
            }
            SHADERLINK 	OCT_MATERIAL_MEDIUM { ACCEPT {ScatteringMedium;  AbsorptionMedium; } }
    }

    GROUP ID_MATERIAL_COMMON_GROUP
    {
         OPEN;
         BOOL 	OCT_MATERIAL_MATTE {}
         BOOL 	OCT_MATERIAL_SMOOTH {}
         BOOL 	OCT_MATERIAL_AFFECT_ALPHA {}
         REAL 	OCT_MATERIAL_ROUNDED_EDGES {  MIN 0.0; STEP 0.001; MAX 100.0;  UNIT METER; }

        LONG OCT_MATERIAL_SHADER2TEXTURE
        {
            CYCLE
            {
                OCT_MATERIAL_PREVIEWSIZE_DEF;
                OCT_MATERIAL_PREVIEWSIZE_128;
                OCT_MATERIAL_PREVIEWSIZE_256;
                OCT_MATERIAL_PREVIEWSIZE_512;
                OCT_MATERIAL_PREVIEWSIZE_1024;
                OCT_MATERIAL_PREVIEWSIZE_2048;
                OCT_MATERIAL_PREVIEWSIZE_4096;
                OCT_MATERIAL_PREVIEWSIZE_8192;
            }
        }
        LONG 	OCT_MATERIAL_VTXMAP_RES  {  MIN 4; STEP 1; MAX 64;  }
        //LONG 	OCT_MATERIAL_VTXMAP_BLUR {  MIN 0; STEP 1; MAX 64;  }

        PARENTCOLLAPSE;
    }

    GROUP ID_OCT_MATERIALGROUP_EDITOR
    {
        BOOL OCT_MATERIAL_ANIMATEPREVIEW { }

        LONG OCT_MATERIAL_PREVIEWSIZE
        {
            CYCLE
            {
                OCT_MATERIAL_PREVIEWSIZE_DEF;
                OCT_MATERIAL_PREVIEWSIZE_NO_SCALE;
                OCT_MATERIAL_PREVIEWSIZE_64;
                OCT_MATERIAL_PREVIEWSIZE_128;
                OCT_MATERIAL_PREVIEWSIZE_256;
                OCT_MATERIAL_PREVIEWSIZE_512;
                OCT_MATERIAL_PREVIEWSIZE_1024;
                OCT_MATERIAL_PREVIEWSIZE_2048;
                OCT_MATERIAL_PREVIEWSIZE_4096;
                OCT_MATERIAL_PREVIEWSIZE_8192;
                OCT_MATERIAL_PREVIEWSIZE_16384;
            }
        }

        LONG OCT_MATERIAL_EDITORDISPLAY
        {
            CYCLE
            {
                OCT_MATERIAL_EDITORDISPLAY_COMBINED;
                OCT_MATERIAL_EDITORDISPLAY_COLOR;
                OCT_MATERIAL_EDITORDISPLAY_DIFFUSION;
                OCT_MATERIAL_EDITORDISPLAY_LUMINANCE;
                OCT_MATERIAL_EDITORDISPLAY_TRANSPARENCY;
                OCT_MATERIAL_EDITORDISPLAY_REFLECTION;
                OCT_MATERIAL_EDITORDISPLAY_ENVIRONMENT;
                OCT_MATERIAL_EDITORDISPLAY_BUMP;
                OCT_MATERIAL_EDITORDISPLAY_ALPHA;
                OCT_MATERIAL_EDITORDISPLAY_SPECULARCOLOR;
                OCT_MATERIAL_EDITORDISPLAY_DISPLACEMENT;
                OCT_MATERIAL_EDITORDISPLAY_NORMAL;
            }
        }
    }

    GROUP
    {
    }
    INCLUDE Massign;
}
